package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification

class StopCodeSpec extends Specification {
    def stopCode = new StopCode('123', '456');

    def 'StopCode matches when corresponding primary and secondary stop codes are the same'()  {
        expect:
        StopCode.match(new StopCode('123', '456'), stopCode)
    }

    def 'StopCode doesn\'t match when corresponding primary and/or secondary stop codes are non-null and aren\'t the same'() {
        expect:
        !StopCode.match(new StopCode(primary, secondary), stopCode)

        where:
        primary | secondary
        '000'   | '456'
        '123'   | '000'
        '000'   | '000'
    }

    def 'StopCode matches any corresponding primary or secondary stop codes when the base value is null'() {
        expect:
        StopCode.match(new StopCode(primary, secondary), stopCode)

        where:
        primary | secondary
        null    | '456'
        '123'   | null
        null    | null
    }

    def 'StopCode matches any of a collection of stop code pairs'() {
        given:
        def containsMatch = [
                [primary: '000', secondary: '000'],
                [primary: '123', secondary: '456']
        ].collect { it as StopCode }

        def containsNoMatch = [
                [primary: '000', secondary: '000'],
                [primary: '123', secondary: '000'],
                [primary: '000', secondary: '456']
        ].collect { it as StopCode }

        expect:
        StopCode.matchAny(containsMatch, stopCode)
        !StopCode.matchAny(containsNoMatch, stopCode)
    }

}

